library(stringr)
library(tidyr)
library(dplyr)
library(ggplot2)
library(ggthemes)

#Load function
source("getDataFromOddsChecker.R")

#Load World Cup Winner table
worldCupWinner <- oddschecker("football/world-cup/germany-v-mexico/winner")
#Set row name as an additional column
worldCupWinner <- add_rownames(worldCupWinner)
names(worldCupWinner)[1] <- "Event"
#Transpose data
worldCupWinner <- worldCupWinner %>% gather("Source", "Bet", 2:ncol(worldCupWinner))
#remove empty values
worldCupWinner <- worldCupWinner %>% filter(Bet != "")
#Get first element into a separate column
numbersInSeparateColumns <- str_split(worldCupWinner$Bet, "/")
firstElement <- c()
for (listItem in seq_along(numbersInSeparateColumns)) {
  listItemValue <- numbersInSeparateColumns[[listItem]][[1]]
  firstElement <- c(firstElement, listItemValue)
}
firstElement <- as.numeric(firstElement)
firstElement <- as_data_frame(firstElement)
worldCupWinner <- bind_cols(worldCupWinner, firstElement)
names(worldCupWinner)[4] <- "First"
remove(firstElement, listItem, listItemValue)
#Get second element into a separate column
secondElement <- c()
for (listItemTwo in seq_along(numbersInSeparateColumns)) {
  listItemValue <- numbersInSeparateColumns[[listItemTwo]][[2]]
  if (listItemValue == "") {
    listItemValue <- NA
  }
  secondElement <- c(secondElement,listItemValue)
}
secondElement <- as.numeric(secondElement)
secondElement <- as_data_frame(secondElement)
worldCupWinner <- bind_cols(worldCupWinner, secondElement)
names(worldCupWinner)[5] <- "Second"
remove(secondElement, listItemTwo, listItemValue, numbersInSeparateColumns)

#Get factor
worldCupWinner$Factor <- worldCupWinner$First/worldCupWinner$Second
#Create a chart
theChart <- ggplot(worldCupWinner, aes(x = Event, y = Factor, Color = Event)) +
  geom_boxplot() + 
  scale_x_discrete() + 
  geom_jitter() +
  ggtitle(paste("¿Qué dicen las apuestas? Última consulta:", Sys.time())) +
  theme_economist()
print(theChart)
max_Values <- worldCupWinner %>% group_by(Event) %>% summarise(max(Factor))
View(max_Values)
